DROP PROCEDURE [hips].[PatientMasterNameInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 October 2012
-- Description:   Inserts a new record into the Patient Master Name Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterNameInsert]
(
       @PatientMasterId INT
      ,@TitleId INT = NULL
      ,@GivenNames VARCHAR(80)
      ,@FamilyName VARCHAR(80)
      ,@SuffixId VARCHAR(80) = NULL
      ,@NameTypeId INT
	  ,@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
    DECLARE @intErrorCode INT,
			@PatientMasterNameId  INT
    SET @intErrorCode = 0
    INSERT
     INTO [hips].[PatientMasterName]
         ( [PatientMasterId],
           [TitleId],
           [GivenNames],
           [FamilyName],
           [SuffixId],
           [NameTypeId],
           [DateCreated],
           [UserCreated],
           [DateModified],
           [UserModified]
         )
    VALUES
         (
            @PatientMasterId
           ,@TitleId
           ,@GivenNames
           ,@FamilyName
           ,@SuffixId
           ,@NameTypeId
          , GETDATE()
          , @UserModified
          , GETDATE()
          , @UserModified
         )
    SELECT @intErrorCode = @@ERROR 
           , @PatientMasterNameId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
       SELECT   pmn.PatientMasterNameId,
				pmn.PatientMasterId,
				pmn.TitleId,
				t.Description AS Title,
				pmn.GivenNames,
				pmn.FamilyName,
				pmn.SuffixId,
				s.Description AS Suffix,
				pmn.NameTypeId,
				nt.Description AS NameType,
				pmn.DateCreated,
				pmn.UserCreated,
				pmn.DateModified,
				pmn.UserModified
		FROM  hips.PatientMasterName pmn
		LEFT OUTER JOIN hips.Title AS t ON t.TitleId = pmn.TitleId
		LEFT OUTER JOIN hips.Suffix AS s ON s.SuffixId = pmn.SuffixId
		LEFT OUTER JOIN hips.NameType AS nt ON nt.NameTypeId = pmn.NameTypeId
		WHERE pmn.PatientMasterNameId = @PatientMasterNameId
    END
    RETURN(@intErrorCode)
END
GO

